(function () {
    var redirect = intellisense.redirectDefinition;

    function makeAllEnumerable(v) {
        /// <param name="v" type="Object" />
        if (v && typeof v === "object")
            Object.getOwnPropertyNames(v).forEach(function (name) {
                var pd = Object.getOwnPropertyDescriptor(v, name);
                if (!pd.enumerable && pd.configurable) {
                    pd.enumerable = true;
                    Object.defineProperty(v, name, pd);
                }
            });
        return v;
    }

    function wrap(old) {
        /// <param name="old" type="Function" />
        var wrapper = function () {
            var args = [];
            for (var i = 0, len = arguments.length; i < len; i++)
                args.push(makeAllEnumerable(arguments[i]));
            return old.apply(this, args);
        };
        redirect(wrapper, old);
        return wrapper;
    }

    function wrapAllMethods(v) {
        /// <param name="v" type="Object" />
        if (v)
            Object.getOwnPropertyNames(v).forEach(function (name) {
                var value = v[name];
                if (typeof value === "function")
                    v[name] = wrap(value);
            });
        return v;
    }

    if (this.WinJS) {
        wrapAllMethods(WinJS.Namespace);
        wrapAllMethods(WinJS.Class);
    }

    (function () {
        var originalApplicationStart = WinJS.Application.start;
        WinJS.Application.start = function () {
            // Call app.stop() when execution completes to ensure that the subsequent calls to app.start() do not see the app as running.
            var app = this;
            setTimeout(function () {
                app.stop();
            }, 0)
            return originalApplicationStart.apply(this, arguments);
        };
        redirect(WinJS.Application.start, originalApplicationStart);

        var originalPagesDefine = WinJS.UI.Pages.define;
        WinJS.UI.Pages.define = function (uri, members) {
            var result = originalPagesDefine.apply(this, arguments);

            intellisense.callerDefines(result, members);

            if (typeof uri === 'string') {
                intellisense.declareNavigationContainer(result, "Page (" + uri + ")");
            }

            // Set the call contexts for IPageControlMembers
            if (members) {
                var pageInstance = new result();

                if (typeof members.error === 'function') {
                    intellisense.setCallContext(members.error, { thisArg: pageInstance, args: [new Error()] });
                }
                if (typeof members.init === 'function') {
                    intellisense.setCallContext(members.init, { thisArg: pageInstance, args: [document.createElement('element'), {}] });
                }
                if (typeof members.load === 'function') {
                    intellisense.setCallContext(members.load, { thisArg: pageInstance, args: [""] });
                }
                if (typeof members.processed === 'function') {
                    intellisense.setCallContext(members.processed, { thisArg: pageInstance, args: [document.createElement('element'), {}] });
                }
                if (typeof members.ready === 'function') {
                    intellisense.setCallContext(members.ready, { thisArg: pageInstance, args: [document.createElement('element'), {}] });
                }
                if (typeof members.render === 'function') {
                    intellisense.setCallContext(members.render, { thisArg: pageInstance, args: [document.createElement('element'), {}, WinJS.Promise.wrap()] });
                }
            }

            return result;
        };
        redirect(WinJS.UI.Pages.define, originalPagesDefine);

        // Simulate a call to a class' instance/static methods for WinJS.Class.define
        var originalClassDefine = WinJS.Class.define;
        WinJS.Class.define = function (constructor, instanceMembers, staticMembers) {
            var result = originalClassDefine.call(this, constructor, instanceMembers, staticMembers);
            // Go through the instance members to find methods
            if (instanceMembers) {
                var classInstance;
                Object.getOwnPropertyNames(instanceMembers).forEach(function (name) {
                    var member = instanceMembers[name];
                    if (typeof member === 'function') {
                        intellisense.setCallContext(member, {
                            get thisArg() {
                                if (!classInstance) classInstance = new result();
                                return classInstance;
                            }
                        });
                    }
                });
            }
            // Go through the static members to find methods
            if (staticMembers) {
                Object.getOwnPropertyNames(staticMembers).forEach(function (name) {
                    var member = staticMembers[name];
                    if (typeof member === 'function') {
                        intellisense.setCallContext(member, { thisArg: result });
                    }
                });
            }

            return result;
        };
        redirect(WinJS.Class.define, originalClassDefine);

        // Define the caller location property for WinJS.Namespace.define
        var originalNamespaceDefine = WinJS.Namespace.define;
        WinJS.Namespace.define = function (name, members) {
            var result = originalNamespaceDefine.call(this, name, members);
            if (typeof name === 'string' && result) {
                // Get the global object
                var globalObj = (function () {
                     return this;
                })();

                // Define the caller location of parent namespaces that haven't yet been defined
                var path;
                var namespaceParts = name.split(".");
                for (var i = 0; i < namespaceParts.length - 1; i++) {
                    path = ((i === 0) ? namespaceParts[i] : path += "." + namespaceParts[i]);
                    var item = globalObj[path];
                    if (item) {
                        intellisense.callerDefines(item);
                    }
                }

                // Define the caller location of the original namespace
                intellisense.callerDefines(result, members);
            }
            return result;
        };
        redirect(WinJS.Namespace.define, originalNamespaceDefine);

        intellisense.setCallContext(WinJS.Promise, { thisArg: {}, args: [function () { }] });
    })();

    (function () {
        // In the language serivce all promises are completed promises. The completed promise class is private
        // to WinJS, however, we can get access to the prototype through one of the promise instances by
        // getting the instance's constructor's prototype.
        var promisePrototype = WinJS.Promise.as(1).constructor.prototype;

        // Setting the argument calling context of the done and then methods to be an instance of Error().
        // The completion callback is handled in WinJS itself through a <returns> metadata comment.
        var originalDone = promisePrototype.done;
        promisePrototype.done = function (c, e, p) {
            intellisense.setCallContext(e, { thisArg: this, args: [new Error()] });
            return originalDone.apply(this, arguments);
        };
        redirect(promisePrototype.done, originalDone);

        var originalThen = promisePrototype.then;
        promisePrototype.then = function (c, e, p) {
            intellisense.setCallContext(e, { thisArg: this, args: [new Error()] });
            return originalThen.apply(this, arguments);
        };
        redirect(promisePrototype.then, originalThen);
    })();
})();
// SIG // Begin signature block
// SIG // MIIkEAYJKoZIhvcNAQcCoIIkATCCI/0CAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // eGrLiiDRMNV0ZxzMb1tTU8567HBR2dKZy6lrMhyzU0Og
// SIG // gg2TMIIGETCCA/mgAwIBAgITMwAAAI6HkaRXGl/KPgAA
// SIG // AAAAjjANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDExMB4XDTE2MTExNzIyMDkyMVoX
// SIG // DTE4MDIxNzIyMDkyMVowgYMxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xDTALBgNVBAsTBE1PUFIxHjAcBgNVBAMTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjCCASIwDQYJKoZIhvcNAQEB
// SIG // BQADggEPADCCAQoCggEBANCH1EIrfp3ZxnrUosPjFZLS
// SIG // U52VF8lSNvpUv6sQr+nJ58wmU8PCc79t1gDlANzpamc0
// SIG // MPYWF7QBpZV8i7mkLOaLO3n2Iwx5j/NS30ABHMLGA53r
// SIG // Wc9z6dhxOZvwziVZLdLJWwrvftYyDl10EgTsngRTpmsC
// SIG // Z/hNWYt34Csh4O/ApEUSzwN7A8Y5w9Qi3FVcd0L/nLLl
// SIG // VWdoui12an9mU0fVRwrMON6Ne5cZfYLQJviljuWh8F5k
// SIG // EOT56yfG8uAI0A3yZ8DY8i/7idoV+a4PPgCXB9ELPnDU
// SIG // d6tyeEGYB7gXzKKxX+y981Bno9eU8NKLVY9TppWT5rJm
// SIG // z8k3aORjx88CAwEAAaOCAYAwggF8MB8GA1UdJQQYMBYG
// SIG // CisGAQQBgjdMCAEGCCsGAQUFBwMDMB0GA1UdDgQWBBSr
// SIG // yNbtshXSqo7xzO1sOPdFStCKuzBSBgNVHREESzBJpEcw
// SIG // RTENMAsGA1UECxMETU9QUjE0MDIGA1UEBRMrMjMwMDEy
// SIG // K2IwNTBjNmU3LTc2NDEtNDQxZi1iYzRhLTQzNDgxZTQx
// SIG // NWQwODAfBgNVHSMEGDAWgBRIbmTlUAXTgqoXNzcitW2o
// SIG // ynUClTBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vd3d3
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpb3BzL2NybC9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3JsMGEGCCsGAQUF
// SIG // BwEBBFUwUzBRBggrBgEFBQcwAoZFaHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraW9wcy9jZXJ0cy9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3J0MAwGA1UdEwEB
// SIG // /wQCMAAwDQYJKoZIhvcNAQELBQADggIBAESJAqxpU/PE
// SIG // trvUjGBT58psqElpZr6lmkGZOtid0lcCUWr6v5uW26Ym
// SIG // fQlW6NztJXV6pUdSqB5LFlPz7g+awwSVKcGChKRWMfyg
// SIG // ipGVtb9azqkBH2RGoebK8dd0e7+SCFFefDMCXlE7m+XY
// SIG // Ll8CTAmcGkPace3k2eei2nQsF63lDLUY9VQJ1L4cc80g
// SIG // e6T6yNvY2zqu+pDFo72VZa5GLVcpWNaS8GzaY/GPM6J+
// SIG // OHZe3fM17ayaO2KB0E4ZfEh8sAuPOMwtvNU5ZamVwQPi
// SIG // ksm5q9JXCqrcUgsuViej4piXV468qVluJJKOguIJc4LZ
// SIG // NYPMn3/RBI6IuOKag1iw1JrmMfqUR459puJOefPY02oz
// SIG // FlBw8UK7mAnp/8yVVVsIv5JSqAjE8ejx/0DX+Zo2nf26
// SIG // kIXSVT5QrUYf7yUMuJ46SARj73iYol0DDQLY3CCr5la1
// SIG // 3u8WZsPXVYIeT4J4yZ5UGhBgtxerQBORrrAZwZozne4y
// SIG // cs1lzE9GmC0PUWAefPv+2+gHeQf3oTM4/gma2497tjq9
// SIG // hYa4zLx9ATC3ex2pXRu9zE0X925HM9VA32rKLlG4tbnP
// SIG // wwTTO+Xj6RCM66e63qQuM2opLxRK6h7BIjg1BYXvwgQA
// SIG // DWvB2JYUSBWvflKwuGDEUrVKgreFKgBJKiaDJ1pB3r3V
// SIG // Zkm8C5x4cAm8MIIHejCCBWKgAwIBAgIKYQ6Q0gAAAAAA
// SIG // AzANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMCVVMx
// SIG // EzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1Jl
// SIG // ZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3Jh
// SIG // dGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3QgQ2Vy
// SIG // dGlmaWNhdGUgQXV0aG9yaXR5IDIwMTEwHhcNMTEwNzA4
// SIG // MjA1OTA5WhcNMjYwNzA4MjEwOTA5WjB+MQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29k
// SIG // ZSBTaWduaW5nIFBDQSAyMDExMIICIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAg8AMIICCgKCAgEAq/D6chAcLq3YbqqCEE00
// SIG // uvK2WCGfQhsqa+laUKq4BjgaBEm6f8MMHt03a8YS2Avw
// SIG // OMKZBrDIOdUBFDFC04kNeWSHfpRgJGyvnkmc6Whe0t+b
// SIG // U7IKLMOv2akrrnoJr9eWWcpgGgXpZnboMlImEi/nqwhQ
// SIG // z7NEt13YxC4Ddato88tt8zpcoRb0RrrgOGSsbmQ1eKag
// SIG // Yw8t00CT+OPeBw3VXHmlSSnnDb6gE3e+lD3v++MrWhAf
// SIG // TVYoonpy4BI6t0le2O3tQ5GD2Xuye4Yb2T6xjF3oiU+E
// SIG // GvKhL1nkkDstrjNYxbc+/jLTswM9sbKvkjh+0p2ALPVO
// SIG // VpEhNSXDOW5kf1O6nA+tGSOEy/S6A4aN91/w0FK/jJSH
// SIG // vMAhdCVfGCi2zCcoOCWYOUo2z3yxkq4cI6epZuxhH2rh
// SIG // KEmdX4jiJV3TIUs+UsS1Vz8kA/DRelsv1SPjcF0PUUZ3
// SIG // s/gA4bysAoJf28AVs70b1FVL5zmhD+kjSbwYuER8ReTB
// SIG // w3J64HLnJN+/RpnF78IcV9uDjexNSTCnq47f7Fufr/zd
// SIG // sGbiwZeBe+3W7UvnSSmnEyimp31ngOaKYnhfsi+E11ec
// SIG // XL93KCjx7W3DKI8sj0A3T8HhhUSJxAlMxdSlQy90lfdu
// SIG // +HggWCwTXWCVmj5PM4TasIgX3p5O9JawvEagbJjS4NaI
// SIG // jAsCAwEAAaOCAe0wggHpMBAGCSsGAQQBgjcVAQQDAgEA
// SIG // MB0GA1UdDgQWBBRIbmTlUAXTgqoXNzcitW2oynUClTAZ
// SIG // BgkrBgEEAYI3FAIEDB4KAFMAdQBiAEMAQTALBgNVHQ8E
// SIG // BAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAW
// SIG // gBRyLToCMZBDuRQFTuHqp8cx0SOJNDBaBgNVHR8EUzBR
// SIG // ME+gTaBLhklodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20v
// SIG // cGtpL2NybC9wcm9kdWN0cy9NaWNSb29DZXJBdXQyMDEx
// SIG // XzIwMTFfMDNfMjIuY3JsMF4GCCsGAQUFBwEBBFIwUDBO
// SIG // BggrBgEFBQcwAoZCaHR0cDovL3d3dy5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jZXJ0cy9NaWNSb29DZXJBdXQyMDExXzIw
// SIG // MTFfMDNfMjIuY3J0MIGfBgNVHSAEgZcwgZQwgZEGCSsG
// SIG // AQQBgjcuAzCBgzA/BggrBgEFBQcCARYzaHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraW9wcy9kb2NzL3ByaW1h
// SIG // cnljcHMuaHRtMEAGCCsGAQUFBwICMDQeMiAdAEwAZQBn
// SIG // AGEAbABfAHAAbwBsAGkAYwB5AF8AcwB0AGEAdABlAG0A
// SIG // ZQBuAHQALiAdMA0GCSqGSIb3DQEBCwUAA4ICAQBn8oal
// SIG // mOBUeRou09h0ZyKbC5YR4WOSmUKWfdJ5DJDBZV8uLD74
// SIG // w3LRbYP+vj/oCso7v0epo/Np22O/IjWll11lhJB9i0ZQ
// SIG // VdgMknzSGksc8zxCi1LQsP1r4z4HLimb5j0bpdS1HXeU
// SIG // OeLpZMlEPXh6I/MTfaaQdION9MsmAkYqwooQu6SpBQyb
// SIG // 7Wj6aC6VoCo/KmtYSWMfCWluWpiW5IP0wI/zRive/DvQ
// SIG // vTXvbiWu5a8n7dDd8w6vmSiXmE0OPQvyCInWH8MyGOLw
// SIG // xS3OW560STkKxgrCxq2u5bLZ2xWIUUVYODJxJxp/sfQn
// SIG // +N4sOiBpmLJZiWhub6e3dMNABQamASooPoI/E01mC8Cz
// SIG // TfXhj38cbxV9Rad25UAqZaPDXVJihsMdYzaXht/a8/jy
// SIG // FqGaJ+HNpZfQ7l1jQeNbB5yHPgZ3BtEGsXUfFL5hYbXw
// SIG // 3MYbBL7fQccOKO7eZS/sl/ahXJbYANahRr1Z85elCUtI
// SIG // EJmAH9AAKcWxm6U/RXceNcbSoqKfenoi+kiVH6v7RyOA
// SIG // 9Z74v2u3S5fi63V4GuzqN5l5GEv/1rMjaHXmr/r8i+sL
// SIG // gOppO6/8MO0ETI7f33VtY5E90Z1WTk+/gFcioXgRMiF6
// SIG // 70EKsT/7qMykXcGhiJtXcVZOSEXAQsmbdlsKgEhr/Xmf
// SIG // wb1tbWrJUnMTDXpQzTGCFdUwghXRAgEBMIGVMH4xCzAJ
// SIG // BgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAw
// SIG // DgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3Nv
// SIG // ZnQgQ29ycG9yYXRpb24xKDAmBgNVBAMTH01pY3Jvc29m
// SIG // dCBDb2RlIFNpZ25pbmcgUENBIDIwMTECEzMAAACOh5Gk
// SIG // Vxpfyj4AAAAAAI4wDQYJYIZIAWUDBAIBBQCggcAwGQYJ
// SIG // KoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
// SIG // NwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcNAQkE
// SIG // MSIEIK4EGD89Lhdy669zn41hCOS8QGKJyEAo/wUzd0WJ
// SIG // 4ZaMMFQGCisGAQQBgjcCAQwxRjBEoCqAKABiAGEAcwBl
// SIG // AC4AaQBuAHQAZQBsAGwAaQBzAGUAbgBzAGUALgBqAHOh
// SIG // FoAUaHR0cDovL21pY3Jvc29mdC5jb20wDQYJKoZIhvcN
// SIG // AQEBBQAEggEACdkt1ygkiGgz3BUwxJhDIJ4/cfj9nRS9
// SIG // DjTqaheTxswoe7cC7cNlgEDBmtugJEMwz594O1geAolw
// SIG // ewvzniEQ6beasvUNhJsrkl8hs15c1laigkxKBhP+vylJ
// SIG // 9a5CJRTe5uXbb0VdlQ/FCEeuAuUbBYv54k1HDyOS/yK2
// SIG // 0D2ucaB196JxYGb0XjwAj+kdJvFOhNBHUIRAk9+Kf+Gz
// SIG // 3PQEN/TCUZ26bCSNqyyHewiDzRn2+kTXbIqqWLcWxfYB
// SIG // IanXgWALcBPW6hiukmLUHPBWSPCAvKHA/bgNoymxbIPv
// SIG // 9LYwUcTQZInIvbXG86USydH9KyS/T+gfPX3AF/xyhg2S
// SIG // PKGCE00wghNJBgorBgEEAYI3AwMBMYITOTCCEzUGCSqG
// SIG // SIb3DQEHAqCCEyYwghMiAgEDMQ8wDQYJYIZIAWUDBAIB
// SIG // BQAwggE9BgsqhkiG9w0BCRABBKCCASwEggEoMIIBJAIB
// SIG // AQYKKwYBBAGEWQoDATAxMA0GCWCGSAFlAwQCAQUABCBf
// SIG // zSHDOgp3XDSN8qZ9O1ytXU76JyXJAiSf62+BIpObRgIG
// SIG // WIui7EHaGBMyMDE3MDIwOTAzNDMzMS44MjhaMAcCAQGA
// SIG // AgH0oIG5pIG2MIGzMQswCQYDVQQGEwJVUzETMBEGA1UE
// SIG // CBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEe
// SIG // MBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMQ0w
// SIG // CwYDVQQLEwRNT1BSMScwJQYDVQQLEx5uQ2lwaGVyIERT
// SIG // RSBFU046QzBGNC0zMDg2LURFRjgxJTAjBgNVBAMTHE1p
// SIG // Y3Jvc29mdCBUaW1lLVN0YW1wIFNlcnZpY2Wggg7QMIIG
// SIG // cTCCBFmgAwIBAgIKYQmBKgAAAAAAAjANBgkqhkiG9w0B
// SIG // AQsFADCBiDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldh
// SIG // c2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNV
// SIG // BAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEyMDAGA1UE
// SIG // AxMpTWljcm9zb2Z0IFJvb3QgQ2VydGlmaWNhdGUgQXV0
// SIG // aG9yaXR5IDIwMTAwHhcNMTAwNzAxMjEzNjU1WhcNMjUw
// SIG // NzAxMjE0NjU1WjB8MQswCQYDVQQGEwJVUzETMBEGA1UE
// SIG // CBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEe
// SIG // MBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSYw
// SIG // JAYDVQQDEx1NaWNyb3NvZnQgVGltZS1TdGFtcCBQQ0Eg
// SIG // MjAxMDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
// SIG // ggEBAKkdDbx3EYo6IOz8E5f1+n9plGt0VBDVpQoAgoX7
// SIG // 7XxoSyxfxcPlYcJ2tz5mK1vwFVMnBDEfQRsalR3OCROO
// SIG // fGEwWbEwRA/xYIiEVEMM1024OAizQt2TrNZzMFcmgqNF
// SIG // DdDq9UeBzb8kYDJYYEbyWEeGMoQedGFnkV+BVLHPk0yS
// SIG // wcSmXdFhE24oxhr5hoC732H8RsEnHSRnEnIaIYqvS2SJ
// SIG // UGKxXf13Hz3wV3WsvYpCTUBR0Q+cBj5nf/VmwAOWRH7v
// SIG // 0Ev9buWayrGo8noqCjHw2k4GkbaICDXoeByw6ZnNPOcv
// SIG // RLqn9NxkvaQBwSAJk3jN/LzAyURdXhacAQVPIk0CAwEA
// SIG // AaOCAeYwggHiMBAGCSsGAQQBgjcVAQQDAgEAMB0GA1Ud
// SIG // DgQWBBTVYzpcijGQ80N7fEYbxTNoWoVtVTAZBgkrBgEE
// SIG // AYI3FAIEDB4KAFMAdQBiAEMAQTALBgNVHQ8EBAMCAYYw
// SIG // DwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAWgBTV9lbL
// SIG // j+iiXGJo0T2UkFvXzpoYxDBWBgNVHR8ETzBNMEugSaBH
// SIG // hkVodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20vcGtpL2Ny
// SIG // bC9wcm9kdWN0cy9NaWNSb29DZXJBdXRfMjAxMC0wNi0y
// SIG // My5jcmwwWgYIKwYBBQUHAQEETjBMMEoGCCsGAQUFBzAC
// SIG // hj5odHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpL2Nl
// SIG // cnRzL01pY1Jvb0NlckF1dF8yMDEwLTA2LTIzLmNydDCB
// SIG // oAYDVR0gAQH/BIGVMIGSMIGPBgkrBgEEAYI3LgMwgYEw
// SIG // PQYIKwYBBQUHAgEWMWh0dHA6Ly93d3cubWljcm9zb2Z0
// SIG // LmNvbS9QS0kvZG9jcy9DUFMvZGVmYXVsdC5odG0wQAYI
// SIG // KwYBBQUHAgIwNB4yIB0ATABlAGcAYQBsAF8AUABvAGwA
// SIG // aQBjAHkAXwBTAHQAYQB0AGUAbQBlAG4AdAAuIB0wDQYJ
// SIG // KoZIhvcNAQELBQADggIBAAfmiFEN4sbgmD+BcQM9naOh
// SIG // IW+z66bM9TG+zwXiqf76V20ZMLPCxWbJat/15/B4vceo
// SIG // niXj+bzta1RXCCtRgkQS+7lTjMz0YBKKdsxAQEGb3FwX
// SIG // /1z5Xhc1mCRWS3TvQhDIr79/xn/yN31aPxzymXlKkVIA
// SIG // rzgPF/UveYFl2am1a+THzvbKegBvSzBEJCI8z+0DpZaP
// SIG // WSm8tv0E4XCfMkon/VWvL/625Y4zu2JfmttXQOnxzplm
// SIG // kIz/amJ/3cVKC5Em4jnsGUpxY517IW3DnKOiPPp/fZZq
// SIG // kHimbdLhnPkd/DjYlPTGpQqWhqS9nhquBEKDuLWAmyI4
// SIG // ILUl5WTs9/S/fmNZJQ96LjlXdqJxqgaKD4kWumGnEcua
// SIG // 2A5HmoDF0M2n0O99g/DhO3EJ3110mCIIYdqwUB5vvfHh
// SIG // AN/nMQekkzr3ZUd46PioSKv33nJ+YWtvd6mBy6cJrDm7
// SIG // 7MbL2IK0cs0d9LiFAR6A+xuJKlQ5slvayA1VmXqHczsI
// SIG // 5pgt6o3gMy4SKfXAL1QnIffIrE7aKLixqduWsqdCosnP
// SIG // GUFN4Ib5KpqjEWYw07t0MkvfY3v1mYovG8chr1m1rtxE
// SIG // PJdQcdeh0sVV42neV8HR3jDA/czmTfsNv11P6Z0eGTgv
// SIG // vM9YBS7vDaBQNdrvCScc1bN+NR4Iuto229Nfj950iEkS
// SIG // MIIE2jCCA8KgAwIBAgITMwAAAKPvHyIggWPcpQAAAAAA
// SIG // ozANBgkqhkiG9w0BAQsFADB8MQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMSYwJAYDVQQDEx1NaWNyb3NvZnQgVGltZS1TdGFt
// SIG // cCBQQ0EgMjAxMDAeFw0xNjA5MDcxNzU2NDlaFw0xODA5
// SIG // MDcxNzU2NDlaMIGzMQswCQYDVQQGEwJVUzETMBEGA1UE
// SIG // CBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEe
// SIG // MBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMQ0w
// SIG // CwYDVQQLEwRNT1BSMScwJQYDVQQLEx5uQ2lwaGVyIERT
// SIG // RSBFU046QzBGNC0zMDg2LURFRjgxJTAjBgNVBAMTHE1p
// SIG // Y3Jvc29mdCBUaW1lLVN0YW1wIFNlcnZpY2UwggEiMA0G
// SIG // CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCp0R6XxxNp
// SIG // +Dg7FRfmSA75X4KsVJ0wGq0QXdDyBfc/aIY3WtAAU+ac
// SIG // bRxo8inH1v8xmFJNEbr1wWSGOjkJJ1ZJXp+hIRkpG8xa
// SIG // FuPzfQFVFyzp4ayW+8eZryhwAHUi+i5ylFRfutHFrDLU
// SIG // 5dYeefCBowq+Y754aWfij4XRyb7If5CL5Lh+mK5vvipk
// SIG // CBpItzkhyGr0JEtgENRygHIIOOlu+TtT7VnbJNRNYchb
// SIG // 02ljADK9zLFRPetAuH+4vrtyHcE4bN4Jjm4tmTpsRQje
// SIG // s09bbW2Akdkjm0iZTB7lEX+zF552kb3iJhYfEQAcOt+Z
// SIG // 6Cz/7HUsWClwpxctKO6PtKNfAgMBAAGjggEbMIIBFzAd
// SIG // BgNVHQ4EFgQU+oW6ZmboRpnacJ+6ISVA2+DosXAwHwYD
// SIG // VR0jBBgwFoAU1WM6XIoxkPNDe3xGG8UzaFqFbVUwVgYD
// SIG // VR0fBE8wTTBLoEmgR4ZFaHR0cDovL2NybC5taWNyb3Nv
// SIG // ZnQuY29tL3BraS9jcmwvcHJvZHVjdHMvTWljVGltU3Rh
// SIG // UENBXzIwMTAtMDctMDEuY3JsMFoGCCsGAQUFBwEBBE4w
// SIG // TDBKBggrBgEFBQcwAoY+aHR0cDovL3d3dy5taWNyb3Nv
// SIG // ZnQuY29tL3BraS9jZXJ0cy9NaWNUaW1TdGFQQ0FfMjAx
// SIG // MC0wNy0wMS5jcnQwDAYDVR0TAQH/BAIwADATBgNVHSUE
// SIG // DDAKBggrBgEFBQcDCDANBgkqhkiG9w0BAQsFAAOCAQEA
// SIG // HdFFulu0v4rmho1FzjWIJhJGsDODamExyBZz+OYkemrB
// SIG // wBU3PI3HKQ1Iy3SXpbKH4QZ41UOMUzrw4lEOeLbT/ByN
// SIG // JeVTGhXZPnq8x7vBTmZYURgPZSVhIaG+5pHDYI75CbQ+
// SIG // iMKmcoE7HPIQHNUFrohdNFVSqEOGjPANVL5L5EvuF5W2
// SIG // m7wCaxbNsi1s9avfNeEGg7RZQeceAfNoTffY3iQsRktC
// SIG // wI0Xc0RQK43eds1/dF3f5mTMMriewM9lUhEIBnqXtoNl
// SIG // o2LYw4O6OY5HuFOqw2YaHL1JTvTc1Aes0rjRZPngd8ns
// SIG // doDEqxcr6yODtZaJ8dhLlpLdb6nCO9bznKGCA3kwggJh
// SIG // AgEBMIHjoYG5pIG2MIGzMQswCQYDVQQGEwJVUzETMBEG
// SIG // A1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9u
// SIG // ZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9u
// SIG // MQ0wCwYDVQQLEwRNT1BSMScwJQYDVQQLEx5uQ2lwaGVy
// SIG // IERTRSBFU046QzBGNC0zMDg2LURFRjgxJTAjBgNVBAMT
// SIG // HE1pY3Jvc29mdCBUaW1lLVN0YW1wIFNlcnZpY2WiJQoB
// SIG // ATAJBgUrDgMCGgUAAxUANeSj+04//yYNcfVtXhJ7kZY4
// SIG // po2ggcIwgb+kgbwwgbkxCzAJBgNVBAYTAlVTMRMwEQYD
// SIG // VQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25k
// SIG // MR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24x
// SIG // DTALBgNVBAsTBE1PUFIxJzAlBgNVBAsTHm5DaXBoZXIg
// SIG // TlRTIEVTTjo1N0Y2LUMxRTAtNTU0QzErMCkGA1UEAxMi
// SIG // TWljcm9zb2Z0IFRpbWUgU291cmNlIE1hc3RlciBDbG9j
// SIG // azANBgkqhkiG9w0BAQUFAAIFANxGKbswIhgPMjAxNzAy
// SIG // MDgyMzM1MjNaGA8yMDE3MDIwOTIzMzUyM1owdzA9Bgor
// SIG // BgEEAYRZCgQBMS8wLTAKAgUA3EYpuwIBADAKAgEAAgIF
// SIG // zAIB/zAHAgEAAgIXrTAKAgUA3Ed7OwIBADA2BgorBgEE
// SIG // AYRZCgQCMSgwJjAMBgorBgEEAYRZCgMBoAowCAIBAAID
// SIG // FuNgoQowCAIBAAIDB6EgMA0GCSqGSIb3DQEBBQUAA4IB
// SIG // AQA7CFZEzuhDb9apV99ZJ0RdG2FlsKYiMg7MOfyPC/gd
// SIG // gOTe3Wiq7RxKIQ1sDhfBVDl/KbOmrhbUAj+5arPG1nGS
// SIG // qJIyI9a4Ulq1wWSZ4P8kd60n4lfHTSvvym04rhhTLmN2
// SIG // GHjYxTOkyHyThyC5am3iGXwWgmJgwH/Hmzvykkm4R7PK
// SIG // K2ZuYTcQdn6+ubRWOreM5O263QmIfL6Y7RAPXSBLaTDw
// SIG // n0LJLoTsqrg2J8invEQA6NJtV4p/2eYGvxmO5GIcfOqW
// SIG // 51TCMGeKaJekrMwl4u1oBSvWAIr8edtX+zUG2sN0vydF
// SIG // Wk1ml6fPsrXrgnUb55V1rB2tEihp3r/aS57GMYIC9TCC
// SIG // AvECAQEwgZMwfDELMAkGA1UEBhMCVVMxEzARBgNVBAgT
// SIG // Cldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAc
// SIG // BgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEmMCQG
// SIG // A1UEAxMdTWljcm9zb2Z0IFRpbWUtU3RhbXAgUENBIDIw
// SIG // MTACEzMAAACj7x8iIIFj3KUAAAAAAKMwDQYJYIZIAWUD
// SIG // BAIBBQCgggEyMBoGCSqGSIb3DQEJAzENBgsqhkiG9w0B
// SIG // CRABBDAvBgkqhkiG9w0BCQQxIgQg0iuX34FLbivwoygA
// SIG // 7Q5sI1SR38I3WBZKe4e3z5djZU0wgeIGCyqGSIb3DQEJ
// SIG // EAIMMYHSMIHPMIHMMIGxBBQ15KP7Tj//Jg1x9W1eEnuR
// SIG // ljimjTCBmDCBgKR+MHwxCzAJBgNVBAYTAlVTMRMwEQYD
// SIG // VQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25k
// SIG // MR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24x
// SIG // JjAkBgNVBAMTHU1pY3Jvc29mdCBUaW1lLVN0YW1wIFBD
// SIG // QSAyMDEwAhMzAAAAo+8fIiCBY9ylAAAAAACjMBYEFDQa
// SIG // cyrzz0lo0GUGVI81VtibQ9e9MA0GCSqGSIb3DQEBCwUA
// SIG // BIIBAIeFkBJpPbuAmG56sOmYFFHbOXEYZ9h8EESvXK50
// SIG // AUtvxGUmHycXZe46nLrTU3neWbvAtvHtGqvw4+uutGWT
// SIG // WnwLcl7csuZpN2l4xhL/i1Be/Uq5ldfdLYZEzOHoAG5J
// SIG // o4s79wJtlkb66QVAn6riDj8FF8EBaWdLgYB6A8A9oZmR
// SIG // 4rqm3OXnJ84JA1UmHsSTHVUHRJLNdjiCwtuDbYC4TDrz
// SIG // 1En7GHwgU/aASPzQGDfuidUN26lbwrSegBGKAML6Uxy6
// SIG // RHg3KtlHK0pRtHzvXr/nW0/VG/3g3rtYRqBaO+vQHuCL
// SIG // Alj7xBDfGWUJwNIjdYlKi1RwWNsVV5ojB2IAz7M=
// SIG // End signature block
